<?php
ob_start();
session_start();

require_once('config/config.php');
require_once("api/factory/userFactory.php");

use \Factory\UserFactory;

if(isset($_SESSION['user_id']) && !empty($_SESSION['user_id'])){
    header("Location: ".$_SERVER['HTTP_ORIGIN']);
    die();
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (empty($_POST["username"])) {
        $isShowError = "กรุณาระบุชื่อผู้ใช้";
    }

    else if (empty($_POST["password"])) {
        $isShowError = "กรุณาระบุรหัสผ่าน";
    }
    else{
        
        $services = new UserFactory($servername, $username, $password, $dbName);

        $username = $_POST["username"];
        $password = $_POST["password"];

        $hash_password = md5($password);

        $result = $services->doLogOn($username, $hash_password);

        if($result > 0){
            $_SESSION['user_id'] = $result;
            header("Location: ".$_SERVER['HTTP_ORIGIN']);
            die();
        }
        else{
            $isShowError = "ผู้ใช้งานไม่ถูกต้อง";
        }
    }
}



?>

<!DOCTYPE html>
<html>

<head>
    <title>Grakcu :: Backoffice</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>
</head>

<body>
    <div class='container'>
        <div class="row justify-content-md-center">
            <h2>กรุณากรอก Username และ Password เพื่อเข้าสู่ระบบ</h2>
        </div>
        <form class="form-horizontal" method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>">
            <div class="form-group">
                <label class="control-label col-sm-4" htmlFor="user">Username:</label>
                <div class="col-sm-4">
                    <input type="text" class="form-control" name="username" placeholder="Enter username" />
                </div>
            </div>
            <div class="form-group">
                <label class="control-label col-sm-4" htmlFor="pwd">Password:</label>
                <div class="col-sm-4">
                    <input type="password" class="form-control" name="password" placeholder="Enter password" />
                </div>
            </div>
            <div class="form-group">
                <div class="col-sm-offset-4 col-sm-4">
                    <button type="submit" class="btn btn-default">Login</button>
                </div>
            </div>
            
            <?php 

                if (isset($isShowError)){
                    echo "<div class='alert alert-danger'><strong>Danger!</strong> ".$isShowError."</div";
                }
            
            ?>

        </form>
    </div>
</body>
</html>