<?php
ob_start();
session_start();

require_once('../config/config.php');
require_once("factory/newsFactory.php");

use \Factory\NewsFactory;
$news = new NewsFactory($servername, $username, $password, $dbName);

if(!isset($_SESSION['user_id']) && empty($_SESSION['user_id'])){
    header("Location: login.php");
    die();
}

/*******************************************************
 * Only these origins will be allowed to upload images *
 ******************************************************/
$accepted_origins = array("http://localhost", "http://192.168.1.1", "http://pear.mrronalz.com", "http://admin.grakcucenter.com", "http://www.admin.grakcucenter.com");

/*********************************************
 * Change this line to set the upload folder *
 *********************************************/
$imageFolder = "../images/";

$userId = $_SESSION['user_id'];
$title = $_POST["title"];
$detail = $_POST["detail"];
$filename = empty($_POST["filename"]) ? null : $_POST["filename"];
$categoryId = $_POST["categoryId"];

reset ($_FILES);
$temp = current($_FILES);

if (is_uploaded_file($temp['tmp_name'])){
    if (in_array($_SERVER['HTTP_ORIGIN'], $accepted_origins)) {
        header('Access-Control-Allow-Origin: ' . $_SERVER['HTTP_ORIGIN']);
    } else {
        header("HTTP/1.0 403 Origin Denied");
        echo json_encode(array('success' => 403, 'message' => 'Origin Denied'));
        return;
    }

    // Verify extension
    if (!in_array(strtolower(pathinfo($temp['name'], PATHINFO_EXTENSION)), array('jpg', 'jpeg', 'png', 'gif'))) {
        //header("HTTP/1.0 500 Invalid extension.");
        echo json_encode(array('success' => 403, 'message' => 'only image .jpg, .jpeg, .png, .gif'));
        return;
    }

    if(trim($temp["tmp_name"]) != "")
	{
        $images = $temp["tmp_name"];
		$new_images = "thumbnails_".$temp["name"];
		copy($temp["tmp_name"],"../images/thumbnail/".$temp["name"]);
        
        $extension = strtolower(pathinfo($temp['name'], PATHINFO_EXTENSION));
        switch ($extension) {
            case 'jpg':
                $images_orig = imagecreatefromjpeg("{$images}");
                break;
            case 'jpeg':
                $images_orig = imagecreatefromjpeg("{$images}");
                break;
            case 'png':
                $images_orig = imagecreatefrompng("{$images}");
                break;
            case 'gif':
                $img = imagecreatefromgif("{$images}");
                break;
            default:
                $images_orig = imagecreatefromjpeg("{$images}");
        }

        $filename = $new_images;

        $thumbWidth = 500;
        // load image and get image size
        $width = imagesx($images_orig);
        $height = imagesy($images_orig);
        
        // calculate thumbnail size
        $new_width = $thumbWidth;
        //$new_height = floor($height * ( $thumbWidth / $width ));
        $new_height = $thumbWidth - 100;

        // create a new temporary image
        $tmp_img = imagecreatetruecolor($new_width, $new_height);

        // copy and resize old image into new image
        imagecopyresized($tmp_img, $images_orig, 0, 0, 0, 0, $new_width, $new_height, $width, $height);

        // save thumbnail into a file
        imagejpeg($tmp_img,"../images/thumbnail/".$new_images, 100);

        // delete orig
        if(file_exists("../images/thumbnail/".$temp["name"])){
            unlink("../images/thumbnail/".$temp["name"]);
        }
        // destroy
        ImageDestroy($tmp_img);
        ImageDestroy($images_orig);
	}
}

if(isset($_GET["id"])){
    $id = $_GET["id"];
    echo json_encode($news->doUpdate($id, $title, $detail, $filename, $categoryId, $userId));
} 
else {
    echo json_encode($news->doSave($title, $detail, $filename, $categoryId, $userId));
}
?>