<?php
session_start();

require_once '../vendor/autoload.php';
include_once 'controller/userController.php';
include_once 'controller/newsController.php';
include_once 'controller/categoryController.php';

use \Psr\Http\Message\ServerRequestInterface as Request;
use \Psr\Http\Message\ResponseInterface as Response;
use Slim\Http\UploadedFile;

$app = new \Slim\App;

$app->get('/{path?}', function (Request $request, Response $response, array $args) {
    return $response;
});

//API for User
$app->get('/user/me', \UserController::class . ':GetName');
$app->get('/user/personal', \UserController::class . ':GetPersonal');

//API for News
$app->post('/news', \NewsController::class . ':Save');
$app->get('/news/all', \NewsController::class . ':GetNews');
$app->get('/news/{id}', \NewsController::class . ':Detail');
$app->get('/news/delete/{id}', \NewsController::class . ':DeleteId');
$app->post('/news/{id}', \NewsController::class . ':Edit');

$app->get('/images/{id}', \NewsController::class . ':DeleteImages');

//API for Category
$app->get('/category/type', \CategoryController::class . ':GetAll');
$app->get('/category/all', \CategoryController::class . ':GetCategory');
$app->put('/category/{id}', \CategoryController::class . ':UpdateCategory');

$app->run();