<?php

include_once '../config/config.php';
include_once 'factory/userFactory.php';

use \Interop\Container\ContainerInterface as ContainerInterface;
use \Factory\UserFactory;

class UserController 
{
    protected $container;
    protected $_user;
    protected $servername;
    protected $username;
    protected $password;
    protected $dbName;
    
   // constructor receives container instance
   public function __construct(ContainerInterface $container) {
        $this->servername = $GLOBALS['servername'];
        $this->username = $GLOBALS['username'];
        $this->password = $GLOBALS['password'];
        $this->dbName = $GLOBALS['dbName'];

        $this->container = $container;
        $this->_user = new UserFactory($this->servername, $this->username, $this->password,  $this->dbName);
   }
   
   
   public function GetPersonal($request, $response, $args) {
        if (!isset($_SESSION['user_id'])){
            return $response->withStatus(302);
        }

        $userId = $_SESSION['user_id'];
        $result =  $this->_user->doGetPersonal($userId);

        return $response->withJson($result);
    }

    public function GetName($request, $response, $args){
        if (!isset($_SESSION['user_id'])){
            return $response->withStatus(302);
        }
        
        
        $userId = $_SESSION['user_id'];
        $result =  $this->_user->doGetName($userId);
        
        return $response->write($result);
    }
}

?>