<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include_once '../config/config.php';
include_once 'factory/newsFactory.php';

use \Interop\Container\ContainerInterface as ContainerInterface;
use Slim\Http\UploadedFile;
use \Factory\NewsFactory;

class NewsController 
{
    protected $container;
    protected $_news;
    protected $servername;
    protected $username;
    protected $password;
    protected $dbName;
    
   // constructor receives container instance
   public function __construct(ContainerInterface $container) {
        $this->servername = $GLOBALS['servername'];
        $this->username = $GLOBALS['username'];
        $this->password = $GLOBALS['password'];
        $this->dbName = $GLOBALS['dbName'];

        $this->_news = new NewsFactory($this->servername, $this->username, $this->password,  $this->dbName);
        $this->container = $container;
   }

    public function Save($request, $response, $args){
        if(!isset($_SESSION['user_id']) && empty($_SESSION['user_id'])){
            return $response->withStatus(302)->write("Unauthorized");
        }

        $uploadedFiles = $request->getUploadedFiles();
        $parsedBody = $request->getParsedBody();
        
        $title = $parsedBody['title'];
        $fromDate = null; //date($parsedBody['fromDate']);
        $detail = addslashes($parsedBody['detail']);
        $userId = $_SESSION['user_id'];
        $categoryId = $parsedBody['categoryId'];
        
        $filename = null;
        if(!empty($uploadedFiles)){
            $uploadedFile = $uploadedFiles["file"];
            $filename = $this->moveUploadedFile($uploadedFile);
        }

        $result = $this->_news->doSave($title, $detail, $filename, $categoryId, $userId);

        return $response->withJson($result);
    }

   public function Edit($request, $response, $args){
        if(!isset($_SESSION['user_id']) && empty($_SESSION['user_id'])){
            return $response->withStatus(302)->write("Unauthorized");
        }
        
        $uploadedFiles = $request->getUploadedFiles();
        $parsedBody = $request->getParsedBody();

        $id = $args["id"];
        $title = $parsedBody['title'];
        $detail = addslashes($parsedBody['detail']);
        $userId = $_SESSION['user_id'];
        $categoryId = $parsedBody['categoryId'];
        $filename = $parsedBody['filename'];

        if(!empty($uploadedFiles)){
            $uploadedFile = $uploadedFiles["file"];
            $filename = $this->moveUploadedFile($uploadedFile);
        }

        $result = $this->_news->doUpdate($id, $title, $detail, $filename, $categoryId, $userId);

        return $response->withJson($result);
   }

   public function GetNews($request, $response, $args){
        $reslt = $this->_news->doGetNews();
        return $response->withJson($reslt);
   }

    public function Detail($request, $response, $args){
        $id = $args["id"];
        $result = $this->_news->doDetail($id);
        return $response->withJson($result);
    }

    public function DeleteId($request, $response, $args){
        $id = $args["id"];
        
        $img = $this->_news->doGetThumbnail($id);
        $result = $this->_news->doDelete($id);

        if($result["success"] == 200){
            if(!empty($img)){
                if(file_exists("../images/thumbnail/".$img)){
                    unlink("../images/thumbnail/".$img);
                }
            }
        }

        return $response->withJson($result);
    }

    public function moveUploadedFile(UploadedFile $uploadedFile)
    {
        $pathFileName = "../images/thumbnail";

        $extension = pathinfo($uploadedFile->getClientFilename(), PATHINFO_EXTENSION);
        $basename = bin2hex($this->RandomToken()); // see http://php.net/manual/en/function.random-bytes.php
        $filename = sprintf('%s.%0.8s', $basename, $extension);
    
        $uploadedFile->moveTo($pathFileName . DIRECTORY_SEPARATOR . $filename);
    
        return $filename;
    }

    public function RandomToken(){
        $date = new DateTime();
        $timestamp = $date->getTimestamp();
        return $timestamp;
    }

    public function DeleteImages($request, $response, $args){
        try{
            $namelist = $args["id"];
            $pathFileName = "../images/";
            $filesList = explode(",", $namelist);

            foreach ($filesList as $name){
                if(file_exists($pathFileName."".$name)){
                    unlink($pathFileName."".$name);
                }
            }
            
            return $response->withJson(array('success' => 200, 'message' => null));
        }
        catch(Exception $e) {
            return $response->withJson(array('success' => 500, 'message' => $e->getMessage()));
        }
    }

}


?>