<?php

include_once '../config/config.php';
include_once 'factory/categoryFactory.php';

use \Interop\Container\ContainerInterface as ContainerInterface;
use \Factory\CategoryFactory;

class CategoryController 
{
    protected $container;
    protected $_user;
    protected $servername;
    protected $username;
    protected $password;
    protected $dbName;
    
   // constructor receives container instance
   public function __construct(ContainerInterface $container) {
        $this->servername = $GLOBALS['servername'];
        $this->username = $GLOBALS['username'];
        $this->password = $GLOBALS['password'];
        $this->dbName = $GLOBALS['dbName'];

        $this->container = $container;
        $this->_cate = new CategoryFactory($this->servername, $this->username, $this->password,  $this->dbName);
   }

    public function GetAll($request, $response, $args){
        $reslt = $this->_cate->doGetAll();
        return $response->withJson($reslt);
    }

    public function GetCategory($request, $response, $args){
        $reslt = $this->_cate->doGetCategory();
        return $response->withJson($reslt);
    }

    public function UpdateCategory($request, $response, $args){
        if(!isset($_SESSION['user_id']) && empty($_SESSION['user_id'])){
            return $response->withStatus(302)->write("Unauthorized");
        }
        
        $id = $args["id"];
        $nameTh = $parsedBody['nameTh'];
        $nameEn = $parsedBody['nameEn'];
        $userId = $_SESSION['user_id'];

        $reslt = $this->_cate->doUpdateCategory($id, $nameTh, $nameEn, $userId);
        return $response->withJson($reslt);
    }
}

?>