<?php
ob_start();
session_start();

require_once('config/config.php');
require_once("api/factory/userFactory.php");

use \Factory\UserFactory;

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (empty($_POST["oldPassword"])) {
        $isShowError = "กรุณาระบุรหัสผ่านเดิม";
    }

    else if (empty($_POST["newPassword"])) {
        $isShowError = "กรุณาระบุรหัสผ่านใหม่";
    }

    else if (empty($_POST["confirmPassword"])) {
        $isShowError = "กรุณาระบุยืนยันรหัสผ่านใหม่";
    }

    else if($_POST["newPassword"] != $_POST["confirmPassword"]){
        $isShowError = "ยืนยันรหัสผ่านไม่ถูกต้อง";
    }

    else{
        $services = new UserFactory($servername, $username, $password, $dbName);

        $userId = $_SESSION["user_id"];
        $oldPassword = $_POST["oldPassword"];
        $newPassword = $_POST["newPassword"];

        $old_hash_password = md5($oldPassword);
        $new_hash_password = md5($newPassword);

        $IsLogin = $services->doIsLogin($userId, $old_hash_password);
        if($IsLogin > 0){
            $result = $services->doChangePassword($userId, $new_hash_password);
            if($result){
                header("Location: api/logout.php");
                die();
            }
            else{
                $isShowError = "เปลี่ยนรหัสผ่านไม่สำเร็จ";
            }
        }   
        else{
            $isShowError = "ไม่พบข้อมูลผู้ใช้";
        }
    }
    
}

?>

<!DOCTYPE html>
<html>

<head>
    <title>App</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>
</head>

<body>
    <div class='container'>
        <h2>Rest Password</h2>
        <form class="form-horizontal" method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>">
            <div class="form-group">
                <label class="control-label col-sm-2" htmlFor="oldPassword">รหัสผ่านเดิม:</label>
                <div class="col-sm-4">
                    <input type="password" class="form-control" name="oldPassword" placeholder="Enter old password" />
                </div>
            </div>
            <div class="form-group">
                <label class="control-label col-sm-2" htmlFor="newPassword">รหัสผ่านใหม่:</label>
                <div class="col-sm-4">
                    <input type="password" class="form-control" name="newPassword" placeholder="Enter new password" />
                </div>
            </div>
            <div class="form-group">
                <label class="control-label col-sm-2" htmlFor="newPassword">ยืนยันรหัสผ่านใหม่:</label>
                <div class="col-sm-4">
                    <input type="password" class="form-control" name="confirmPassword" placeholder="Enter confirm new password" />
                </div>
            </div>
            <div class="form-group">
                <div class="col-sm-offset-2 col-sm-4">
                    <button type="submit" class="btn btn-default">Submit</button>
                </div>
            </div>
            
            <?php
                if (isset($isShowError)){
                    echo "<div class='alert alert-danger'><strong>Danger!</strong> ".$isShowError."</div>";
                }
            ?>

        </form>
    </div>
</body>
</html>